//Listing 12.6. Klasa kontenera z tablic komponentw o ustalonym rozmiarze oraz iteratorem.
#include <iostream>
using namespace std;

class Sample { // klasa komponentu
  double value; // warto prbki
public:
  Sample (double x = 0) // konstruktor domylny oraz konwertujcy
   { value = x; }
  void set (double x) // metoda modyfikatora
    { value = x; }
  double get () const // metoda selektora
    { return value; } } ;

class History { // klasa kontenera: ustaw warto
  enum { size = 8 };
  Sample data[size]; // tablica prbek o ustalonym rozmiarze
  int count; // liczba poprawnych elementw
  int idx; // indeks biecych prbek
public:
  History() : count(0), idx(0) { } // wyczy tablic
  void add(double); // dodaj prbke na kocu
  Sample& getComponent() // zwr referencj do obiektu klasy Sample
  { return data[idx]; } // moe by komunikat docelowy
  void getFirst()
  { idx = 0; } // pocztek zestawu danych
  bool getNext()
  { return ++idx < count; } // przesu do kolejnego elementu
  void average () const; // wywietl redni
} ;

void History::add(double s)
{ if (count < size)
  data[count++].set(s); } // lub po prostu: data[i++] = s;

void History::average () const
{ cout << "\n Warto rednia: ";
  double sum = 0;
  for (int i = 0; i < count; i++)
    sum += data[i].get();
  cout << sum/count << endl; }

int main()
{ double a[] = {3, 5, 7, 11, 13, 17, 19, 23, 29 } ; // dana wejciowa
  History h; // konstruktor domylny
  for (int i=0; i < 9; i++)
    h.add(a[i]); // dodaj histori
  cout << "\n Historia pomiarw:" << endl << endl;
  h.getFirst(); // zadanie jest przekazane
  do {
      cout << " " << h.getComponent().get(); // wywietl komponenty
    } while (h.getNext());
  h.average();
  return 0;
  }
